/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.refinedstorage;

import com.refinedmods.refinedstorage.api.IRSAPI;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingManager;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorage;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import dan200.computercraft.shared.util.NBTUtil;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorageNode;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class RefinedStorage {
    public static RefinedStorage instance;
    private final IRSAPI api = API.instance();

    public RefinedStorage() {
        this.initiate();
    }

    private static INetworkNode read(CompoundTag tag, NetworkNode node) {
        node.read(tag);
        return node;
    }

    public static ItemStack findStackFromStack(INetwork network, ICraftingManager crafting, ItemStack item) {
        return RefinedStorage.findStackFromFilter(network, crafting, ItemFilter.fromStack(item));
    }

    public static ItemStack findStackFromFilter(INetwork network, ICraftingManager crafting, ItemFilter filter) {
        for (StackListEntry temp : network.getItemStorageCache().getList().getStacks()) {
            if (!filter.test((ItemStack)temp.getStack())) continue;
            return ((ItemStack)temp.getStack()).m_41777_();
        }
        if (crafting == null) {
            return ItemStack.f_41583_;
        }
        for (ICraftingPattern pattern : crafting.getPatterns()) {
            for (ItemStack stack : pattern.getOutputs()) {
                if (!filter.test(stack.m_41777_())) continue;
                return stack.m_41777_();
            }
        }
        return ItemStack.f_41583_;
    }

    public static FluidStack findFluidFromStack(INetwork network, ICraftingManager crafting, FluidStack stack) {
        return RefinedStorage.findFluidFromFilter(network, crafting, FluidFilter.fromStack(stack));
    }

    public static FluidStack findFluidFromFilter(INetwork network, ICraftingManager crafting, FluidFilter filter) {
        for (StackListEntry temp : network.getFluidStorageCache().getList().getStacks()) {
            if (!filter.test((FluidStack)temp.getStack())) continue;
            return ((FluidStack)temp.getStack()).copy();
        }
        if (crafting == null) {
            return FluidStack.EMPTY;
        }
        for (ICraftingPattern pattern : crafting.getPatterns()) {
            if (!pattern.getFluidOutputs().stream().anyMatch(filter::test)) continue;
            return pattern.getFluidOutputs().stream().filter(filter::test).findFirst().get();
        }
        return FluidStack.EMPTY;
    }

    public static Object listFluids(INetwork network) {
        ArrayList fluids = new ArrayList();
        RefinedStorage.getFluids(network).forEach(item -> fluids.add(RefinedStorage.getObjectFromFluid(item, network)));
        return fluids;
    }

    public static Object listItems(INetwork network) {
        ArrayList items = new ArrayList();
        RefinedStorage.getItems(network).forEach(item -> items.add(RefinedStorage.getObjectFromStack(item, network)));
        return items;
    }

    public static boolean isItemCraftable(INetwork network, ItemStack stack) {
        return network.getCraftingManager().getPattern(stack) != null;
    }

    public static boolean isFluidCraftable(INetwork network, FluidStack stack) {
        return network.getCraftingManager().getPattern(stack) != null;
    }

    public static int getMaxItemDiskStorage(INetwork network) {
        int total = 0;
        boolean creative = false;
        for (IStorage store : network.getItemStorageCache().getStorages()) {
            if (!(store instanceof IStorageDisk)) continue;
            IStorageDisk storageDisk = (IStorageDisk)store;
            int cap = storageDisk.getCapacity();
            if (cap > 0) {
                total += cap;
                continue;
            }
            creative = true;
        }
        return creative ? -1 : total;
    }

    public static int getMaxFluidDiskStorage(INetwork network) {
        int total = 0;
        boolean creative = false;
        for (IStorage store : network.getFluidStorageCache().getStorages()) {
            if (!(store instanceof IStorageDisk)) continue;
            IStorageDisk storageDisk = (IStorageDisk)store;
            int cap = storageDisk.getCapacity();
            if (cap > 0) {
                total += cap;
                continue;
            }
            creative = true;
        }
        return creative ? -1 : total;
    }

    public static int getMaxItemExternalStorage(INetwork network) {
        int total = 0;
        for (IStorage store : network.getItemStorageCache().getStorages()) {
            if (!(store instanceof IExternalStorage)) continue;
            IExternalStorage externalStorage = (IExternalStorage)store;
            total = (int)((long)total + externalStorage.getCapacity());
        }
        return total;
    }

    public static int getMaxFluidExternalStorage(INetwork network) {
        int total = 0;
        for (IStorage store : network.getFluidStorageCache().getStorages()) {
            if (!(store instanceof IExternalStorage)) continue;
            IExternalStorage externalStorage = (IExternalStorage)store;
            total = (int)((long)total + externalStorage.getCapacity());
        }
        return total;
    }

    public static Object getObjectFromPattern(ICraftingPattern pattern, INetwork network) {
        if (pattern == null) {
            return null;
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        NonNullList outputsList = pattern.getOutputs();
        ArrayList<Map<String, Object>> outputs = new ArrayList<Map<String, Object>>();
        for (ItemStack itemStack : outputsList) {
            outputs.add(RefinedStorage.getObjectFromStack(itemStack.m_41777_(), network));
        }
        map.put("outputs", outputs);
        List inputList = pattern.getInputs();
        ArrayList inputs = new ArrayList();
        for (List singleInputList : inputList) {
            ArrayList<Map<String, Object>> inputs1 = new ArrayList<Map<String, Object>>();
            for (ItemStack stack : singleInputList) {
                inputs1.add(RefinedStorage.getObjectFromStack(stack.m_41777_(), network));
            }
            inputs.add(inputs1);
        }
        ArrayList<Map<String, Object>> byproducts = new ArrayList<Map<String, Object>>();
        if (!pattern.isProcessing()) {
            NonNullList byproductsList = pattern.getByproducts();
            for (ItemStack stack : byproductsList) {
                byproducts.add(RefinedStorage.getObjectFromStack(stack.m_41777_(), network));
            }
        }
        map.put("inputs", inputs);
        map.put("outputs", outputs);
        map.put("byproducts", byproducts);
        map.put("processing", Boolean.valueOf(pattern.isProcessing()));
        return map;
    }

    public static Map<String, Object> getObjectFromStack(@Nullable ItemStack itemStack, INetwork network) {
        if (itemStack == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        CompoundTag nbt = itemStack.m_41783_();
        Supplier tags = () -> itemStack.m_41720_().m_204114_().m_203616_();
        map.put("fingerprint", ItemUtil.getFingerprint(itemStack));
        map.put("name", itemStack.m_41720_().getRegistryName().toString());
        map.put("amount", itemStack.m_41613_());
        map.put("displayName", itemStack.m_41611_().getString());
        map.put("isCraftable", RefinedStorage.isItemCraftable(network, itemStack));
        map.put("nbt", nbt == null ? null : NBTUtil.toLua((Tag)nbt));
        map.put("tags", tags.get().findAny().isEmpty() ? null : LuaConverter.tagsToList(tags));
        return map;
    }

    public static Map<String, Object> getObjectFromFluid(@Nullable FluidStack fluidStack, INetwork network) {
        if (fluidStack == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Supplier tags = () -> fluidStack.getFluid().m_205069_().m_203616_();
        map.put("name", fluidStack.getFluid().getRegistryName().toString());
        map.put("amount", fluidStack.getAmount());
        map.put("displayName", fluidStack.getDisplayName().getString());
        map.put("isCraftable", RefinedStorage.isFluidCraftable(network, fluidStack));
        map.put("tags", tags.get().findAny().isEmpty() ? null : LuaConverter.tagsToList(tags));
        return map;
    }

    public static Object getItem(INetwork network, ItemStack item) {
        for (ItemStack itemStack : RefinedStorage.getItems(network)) {
            if (!itemStack.m_41656_(item) || !Objects.equals(itemStack.m_41783_(), item.m_41783_())) continue;
            return RefinedStorage.getObjectFromStack(itemStack, network);
        }
        return null;
    }

    public static List<ItemStack> getCraftableItems(INetwork network) {
        IStorageCache cache = network.getItemStorageCache();
        Collection craftableEntries = cache.getCraftablesList().getStacks();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(craftableEntries.size());
        for (StackListEntry entry : craftableEntries) {
            result.add((ItemStack)entry.getStack());
        }
        return result;
    }

    public static List<FluidStack> getCraftableFluids(INetwork network) {
        IStorageCache cache = network.getFluidStorageCache();
        Collection craftableEntries = cache.getCraftablesList().getStacks();
        ArrayList<FluidStack> result = new ArrayList<FluidStack>(craftableEntries.size());
        for (StackListEntry entry : craftableEntries) {
            result.add((FluidStack)entry.getStack());
        }
        return result;
    }

    public static List<ItemStack> getItems(INetwork network) {
        IStorageCache cache = network.getItemStorageCache();
        Collection entries = cache.getList().getStacks();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(entries.size());
        for (StackListEntry entry : entries) {
            result.add(((ItemStack)entry.getStack()).m_41777_());
        }
        return result;
    }

    public static List<FluidStack> getFluids(INetwork network) {
        IStorageCache cache = network.getFluidStorageCache();
        Collection entries = cache.getList().getStacks();
        ArrayList<FluidStack> result = new ArrayList<FluidStack>(entries.size());
        for (StackListEntry entry : entries) {
            result.add(((FluidStack)entry.getStack()).copy());
        }
        return result;
    }

    public void initiate() {
        this.api.getNetworkNodeRegistry().add(new ResourceLocation("advancedperipherals", "rs_bridge"), (tag, world, pos) -> RefinedStorage.read(tag, new RefinedStorageNode(world, pos)));
    }

    public IRSAPI getApi() {
        return this.api;
    }
}

